@extends('admin.admin_master')
@section('admin')


<div class="page-content">
<div class="container-fluid">

<div class="row">
<div class="col-12">
    <div class="card">
        <div class="card-body">

            <h4 class="card-title">Edit User role for {{ $roleData->name .' '. $roleData->sname .' '. $roleData->lname }} </h4><br><br>


            <form method="post" action="{{ route('role.update') }}" >
                @csrf

                <input type="hidden" name="id" value="{{ $roleData->id }}">

            <!-- <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">User name </label>
                <div class="col-sm-6">
                    <input name="name" class="form-control" type="text" value="{{ $roleData->name .' '. $roleData->sname .' '. $roleData->lname }}">
                </div>
            </div> -->
            <!-- end row -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4">Available user roles</h4>

                            <div class="row">

                                <div class="col-md-5">
                                    @foreach($roles as $urole)
                                    <div>
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="urole[]" value="{{ $urole->name }}" {{ in_array($urole->name, $allusers) ? 'checked' : '' }}>
                                            <label class="form-check-label">
                                                {{ ucfirst($urole->name) }}

                                            </label>
                                            
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                        <!-- end row -->


<input type="submit" class="btn btn-info waves-effect waves-light" value="Assign role to user">
            </form>



        </div>
    </div>
</div> <!-- end col -->
</div>



</div>
</div>


<script type="text/javascript">

    $(document).ready(function(){
        $('#myForm').validate({
            rules : {
                name : {
                    required : true,
                },
                mobile_no : {
                    required : true,
                },
                address : {
                    required : true,
                },
                item : {
                    required : true,
                },
            },

            messages : {
                name : {
                    required : 'Name is mandatory',
                },
                mobile_no : {
                    required: 'Mobile number is mandatory',
                },
                address : {
                    required : 'Address is mandatory',
                },
                item : {
                    required : 'Item is mandatory',
                },
            },

            errorElement : 'span',
            errorPlacement : function(error, element) {
                element.addClass('invalid-feedback');
                $(element).errorclosest('.form-group').append(error);
            },

            highlight : function(element, errorClass, validClass) {
                error.addClass('is-invalid');
            },

            unhighlight : function(element, errorClass, validClass) {
                error.removeClass('is-invalid');
            },
        });

    });

</script>



@endsection 