@extends('admin.admin_master')
@section('admin')


<div class="page-content">
<div class="container-fluid">

<div class="row">
<div class="col-12">
    <div class="card">
        <div class="card-body">

            <h4 class="card-title">Edit Payment Method Page </h4><br><br>


            <form method="post" action="{{ route('update.paymenttype') }}" >
                @csrf

                <input type="hidden" name="id" value="{{ $paymenttype->id }}">

            <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"> Select Payment Method Name</label>
                <div class="col-sm-10">
                    <select name="paymentmethod_id" class="form-select" aria-label="Default select example">
                        <option selected="">Open this select menu</option>
                        @foreach($paymentmethod as $pm)
                        <option value="{{ $pm->id }}" {{ $pm->id = $paymenttype->paymentmethod_id ? 'selected' : '' }} >{{ $pm->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- end row -->


            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Payment Type Name </label>
                <div class="col-sm-10">
                    <input name="name" class="form-control" type="text" value="{{ $paymenttype->name }}">
                </div>
            </div>
            <!-- end row -->


<input type="submit" class="btn btn-info waves-effect waves-light" value="Update Payment Type">
            </form>



        </div>
    </div>
</div> <!-- end col -->
</div>



</div>
</div>


<script type="text/javascript">
    
    $(document).ready(function() {
        $('#myForm').validate({
            rules: {
                paymentmethod_id: {
                    required : true,
                },

                name: {
                    required : true,
                },
            },

            messages :{
                paymentmethod_id: {
                    required : 'Payment method field is required',
                },

                name: {
                    required : 'Payment type field is required',
                },
            },

            errorElement : 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },

            highlight : function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },

            unhighlight : function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });

    });

</script>



@endsection 