@extends('admin.admin_master')
@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<div class="page-content">
<div class="container-fluid">

<div class="row">
<div class="col-12">
    <div class="card">
        <div class="card-body">

            <h4 class="card-title">Add Mkopo Page </h4><br><br>


            <form method="post" action="{{ route('store.mkopo') }}" id="myForm" enctype="multipart/form-data" data-parsley-validate>
                @csrf
                

            <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"> Select Member Name </label>
        
                <div class="col-sm-10">
                    <select name="member_id" id="member_id" class="form-control select2" aria-label="Default select example">
                        <option value="" selected disabled>Open this select menu</option>
                        @foreach($allusers as $all)
                        <option value="{{ $all->id }} {{ old('member_id') == $all->id ? 'selected' : '' }}">{{ $all->name." ".$all->sname. " ".$all->lname. "-".$all->membership_no }}</option>
                        @endforeach
                    </select>
                    @error('member_id')
            <div style="color:red;">{{ $message }}</div>
        @enderror
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total Hisa + Akiba </label>
                <div class="form-group col-sm-10">
                    <input name="t_amount" class="form-control" type="text" id="total_hisa_plus_akiba" value="{{ old('t_amount') }}" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Eligible Amount </label>
                <div class="form-group col-sm-10">
                    <input name="e_amount" class="form-control" type="text" value=" {{ old('e_amount') }}" id="e_amount" value="" readonly>
                </div>
            </div>

            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Enter amount </label>
                <div class="form-group col-sm-10">
                    <input name="entered_amount" class="form-control" value="{{ old('entered_amount') }}" type="text" id="entered_amount">
                    @error('entered_amount')
            <div style="color:red;">{{ $message }}</div>@enderror
                </div>
            </div>
            <!-- end row -->


            <div class="row mb-3">
                <label class="col-sm-2 col-form-label">Select Payment period in months</label>
                <div class="col sm-10">
                    <select name="period" id="period_id" class="form-select" aria-label="Default select example">
                        <option selected="">Select period</option>
                        @foreach($period as $pr)
                        <option value="{{ $pr->id }}">{{ $pr->months }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total interest(Percent) </label>
                <div class="form-group col-sm-10">
                    <input name="t_interest" class="form-control" type="text" id="t_interest" value="" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total interest(Tshs) </label>
                <div class="form-group col-sm-10">
                    <input name="t_interest_tsh" class="form-control" type="text" id="t_interest_tsh" value="" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Monthly Loan </label>
                <div class="form-group col-sm-10">
                    <input name="m_loan" class="form-control" type="text" id="m_loan" value="" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Monthly interest(Tshs) </label>
                <div class="form-group col-sm-10">
                    <input name="m_interest_tsh" class="form-control" type="text" id="m_interest_tsh" value="" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total monthly(Tshs) </label>
                <div class="form-group col-sm-10">
                    <input name="t_monthly_tsh" class="form-control" type="text" id="t_monthly_tsh" value="" readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total repaid loan(Tshs) </label>
                <div class="form-group col-sm-10">
                    <input name="t_repaid_tsh" class="form-control" type="text" id="t_repaid_tsh" value="" readonly>
                </div>
            </div>
            <!-- end row -->


            <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"> Chagua mdhamini wa kwanza</label>
                <div class="col-sm-10">
                    <select name="m1_id" id="m1_id" class="form-control select2" aria-label="Default select example">
                        <option selected="">Open this select menu</option>
                        @foreach($allusers as $all)
                        <option value="{{ $all->id }}">{{ $all->name." ".$all->sname. " ".$all->lname. "-".$all->membership_no }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total Hisa za mdhamini wa kwanza </label>
                <div class="form-group col-sm-10">
                    <input name="t_amount_m1" class="form-control" type="text" id="t_amount_m1" value=" " readonly>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"> Chagua mdhamini wa pili</label>
                <div class="col-sm-10">
                    <select name="m2_id" id="m2_id" class="form-control select2" aria-label="Default select example">
                        <option selected="">Open this select menu</option>
                        @foreach($allusers as $all)
                        <option value="{{ $all->id }}">{{ $all->name." ".$all->sname. " ".$all->lname. "-".$all->membership_no }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- end row -->

            <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Total Hisa za mdhamini wa pili </label>
                <div class="form-group col-sm-10">
                    <input name="t_amount_m2" class="form-control" type="text" id="t_amount_m2" value=" " readonly>
                </div>
            </div>
            <!-- end row -->

             <div class="row mb-3">
                <label for="example-text-input" class="col-sm-2 col-form-label">Enter payment date </label>
                <div class="form-group col-sm-10">
                    <input name="pdate" id="pdate" class="form-control" type="date">
                </div>
            </div>
            <!-- end row -->


<input type="submit" class="btn btn-info waves-effect waves-light" value="Add Mkopo">
            </form>



        </div>
    </div>
</div> <!-- end col -->
</div>



</div>
</div>

<!-- <script type="text/javascript">
$(document).ready(function() {
    $('#myForm').validate({
        ignore: [],
        rules: {
            member_id: { required: true },
            entered_amount: { required: true, number: true },
            period: { required: true },
            m1_id: { required: true },
            m2_id: { required: true }
        },
        messages: {
            member_id: { required: 'Member name is required' },
            entered_amount: { required: 'Amount is mandatory' },
            period: { required: 'Period name is mandatory' },
            m1_id: { required: 'Jina la mdhamini no 1 is mandatory' },
            m2_id: { required: 'Jina la mdhamini no 2 is mandatory' }
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function(element) {
            $(element).removeClass('is-invalid');
        }
    });
});
</script> -->

<script type="text/javascript">
    
    $(document).ready(function(){
        $('#image').change(function(e){
            var reader = new FileReader();
            reader.onload = function(e){
                $('#showImage').attr('src',e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });

</script>



    <script type="text/javascript">
    $(function(){
        $(document).on('change','#member_id',function(){
            var member_id = $(this).val();
            $.ajax({
                url:"{{ route('get-user') }}",
                type: "GET",
                data:{member_id:member_id},
                success:function(data){
                    $('#total_hisa_plus_akiba').val(parseFloat(data.total_hisa_akiba).toLocaleString('en-US', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }));
                    $('#e_amount').val(parseFloat(data.total_hisa_akiba*3).toLocaleString('tz', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }));

                    $('#max').val(parseFloat(data.total_hisa_akiba*3).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    })); 

                    $('#entered_amount').attr('placeholder', 'Max:' + parseFloat(data.total_hisa_akiba*3).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    }));          
                }
            })
        });
    });

</script>

<script type="text/javascript">
    $(function(){
        $(document).on('change','#m1_id',function(){
            var member_id = $(this).val();
            $.ajax({
                url:"{{ route('get-user') }}",
                type: "GET",
                data:{member_id:member_id},
                success:function(data){
                    $('#t_amount_m1').val(parseFloat(data.total_hisa_akiba).toLocaleString('en-US', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }));         
                }
            })
        });
    });

</script>

<script type="text/javascript">
    $(function(){
        $(document).on('change','#m2_id',function(){
            var member_id = $(this).val();
            $.ajax({
                url:"{{ route('get-user') }}",
                type: "GET",
                data:{member_id:member_id},
                success:function(data){
                    $('#t_amount_m2').val(parseFloat(data.total_hisa_akiba).toLocaleString('en-US', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }));         
                }
            })
        });
    });

</script>



<script type="text/javascript">
    $(function(){
        $(document).on('change','#period_id','entered_amount',function(){
            var period_id = $(this).val();
            var entered_amount = $('#entered_amount').val();
            $.ajax({
                url:"{{ route('get-calculator') }}",
                type: "GET",
                data:{period_id:period_id, entered_amount:entered_amount},
                success:function(data){
                    $('#t_interest').val(parseFloat(data.total_interest).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    }));

                    $('#t_interest_tsh').val(parseFloat(data.interest_tsh).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    }));

                    $('#m_loan').val(parseFloat(data.monthly_loan).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    })); 

                    $('#m_interest_tsh').val(parseFloat(data.monthy_interest).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    })); 

                    $('#t_monthly_tsh').val(parseFloat(data.total_monthly).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    }));   

                    $('#t_repaid_tsh').val(parseFloat(data.total_repaid_loan).toLocaleString('tz', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 2
                    }));       
                }
            })
        });
    });

</script>

@endsection 