<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mikopos', function (Blueprint $table) {
            $table->id();
            $table->string('member_id')->nullable();
            $table->decimal('total_hisa_plus_akiba', 12, 2)->nullable();
            $table->decimal('amount_given', 12, 2)->nullable();
            $table->integer('period')->nullable();
            $table->decimal('total_interest_percent')->nullable();
            $table->decimal('total_interest_tsh', 12, 2)->nullable();
            $table->decimal('monthly_payment', 12, 2)->nullable();
            $table->decimal('monthly_interest_tsh', 12, 2)->nullable();
            $table->decimal('total_monthly_tsh', 12, 2)->nullable();
            $table->decimal('total_repaid_loan_tsh', 12, 2)->nullable();
            $table->string('m1_member_id')->nullable();
            $table->decimal('m1_total_hisa_plus_akiba', 12, 2)->nullable();
            $table->string('m2_member_id')->nullable();
            $table->decimal('m2_total_hisa_plus_akiba', 12, 2)->nullable();
            $table->date('pdate')->nullable();
            $table->tinyInteger('status')->default('0')->comment('0=Pending, 1=Approved');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mkopos');
    }
};
