<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UpdateProfileController extends Controller
{

    public function destroy(Request $request) {
        Auth::guard('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        $notification = array(
            'message' => 'User successfully logout',
            'alert-type' => 'success',
        );
        return redirect('/login')->with($notification);
    }
    //
    public function Profile() {
        $id = Auth::user()->id;
        $adminData = User::find($id);
        return view('admin.admin_profile_view',compact('adminData'));

        // End of method
    }

    public function editProfile() {

        $id = Auth::user()->id;
        $editData = User::find($id);
        return view('admin.admin_profile_edit',compact('editData'));

        // End of method
    }

    public function storeProfile(Request $request) {

        $id = Auth::user()->id;
        $data = User::find($id);
        $data->name = $request->name;

        if($request->file('profile_image')) {
            $file = $request->file('profile_image');
            $filename = date('YmdHi').$file->getClientOriginalName();
            $file->move(public_path('upload/admin_images'),$filename);

            $data['user_image'] = $filename;

        }
        $data->save();

            $notification = array(
                'message' => 'Profile updated with image successfull',
                'alert-type' => 'info');

            return redirect()->route('admin.profile')->with($notification);

    } // End of method

    public function changePassword() {

        $id = Auth::user()->id;
        $editData = User::find($id);
        return view('admin.admin_change_password', compact('editData'));

    } // End of method

    public function updatePassword(Request $request) {

        $validateData = $request->validate([
            'oldpassword' => 'required',
            'newpassword' => 'required',
            'confirmpassword' => 'required|same:newpassword',
        ]);

        $hashedPassword = Auth::user()->password;
        if(Hash::check($request->oldpassword,$hashedPassword)) {
            $users = User::find(Auth::id());
            $users->password = bcrypt($request->newpassword);
            $users->save();

            session()->flash('message', 'Password updated successfully');
            return redirect()->back();
        } else {
            session()->flash('message', 'Password does not match');
            return redirect()->back();
        }

    } // End of method
    
}