<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Hisa;
use App\Models\User;
use App\Models\PaymentMethod;
use App\Models\PaymentType;
use App\Models\Mikopo;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class HisaController extends Controller
{
    //
    public function addHisa() {

        $allusers = User::all();
        $pmethod = PaymentMethod::all();
        $ptype = PaymentType::all();

        return view('admin.hisa.hisa_add',compact('allusers','pmethod','ptype'));
        
    }
    // End of method

    public function paymentHisa(Request $request) {

        $allusers = User::all();
        $pmethod = PaymentMethod::all();
        $ptype = PaymentType::all();

        if($request->file('risit_image')) {
            $manager = new ImageManager(new Driver());
            $name_gen = hexdec(uniqid()).'.'.$request->file('risit_image')->getClientOriginalExtension();
            $img = $manager->read($request->file('risit_image'));
            $img = $img->resize(1029,519);
            $img->toJpeg(100)->save('upload/hisa/risit/'.$name_gen);
            $save_url = 'upload/hisa/risit/'.$name_gen;
        

        Hisa::insert([
            'member_id' => $request->member_id,
            'paymentmethod_id' => $request->paymentmethod_id,
            'paymenttype_id' => $request->paymenttype_id,
            'amount' => $request->amount,
            'pdate' => $request->pdate,
            'risiti' => $save_url,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);
    }

        $notification = array(
            'message' => 'Hisa record stored successfully',
            'alert-type' => 'success',
        );
        return view('admin.hisa.hisa_add',compact('allusers','pmethod','ptype'));
        
    }
    // End of method

    public function pendinghisa() {
        $all_users = User::all();
        $pending = Hisa::all()->where('status',0);
        return view('admin.hisa.hisa_pending', compact('pending','all_users'));
    }

    public function reviewhisa($id) {
        $h_review = Hisa::findOrFail($id);
        $all_users = User::where('id', $h_review->member_id)->get();
        $p_type = PaymentType::where('id', $h_review->paymenttype_id)->get();
        return view('admin.hisa.hisa_payment_approval', compact('h_review','all_users','p_type'));
    }
    // End of method

    public function approvedhisa(Request $request) {
        $request_id = $request->id;
        $h_approved = Hisa::findOrFail($request_id)->update([
            'status' => 1,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Hisa approved successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('pendinghisa')->with($notification);
    }
    // End of method

    public function rejecthisa(Request $request) {
        $request_id = $request->id;
        $h_rejected = Hisa::findOrFail($request_id)->update([
            'status' => '2',
            'reason' => $request->reason,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);
    }

    // view hisa

    public function view_hisa(Request $request) {
        $view_hisa = Hisa::where('member_id', Auth::user()->id)->where('status',1)->get();
        $total_hisa = Hisa::where('member_id', Auth::user()->id)->where('status',1)->sum('amount');
        $all_users = User::where('id',Auth::user()->id)->get();
        return view('admin.hisa.all_hisa', compact('view_hisa','all_users','total_hisa'));
    }
}
