<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Hisa;
use App\Models\Akiba;
use App\Models\User;
use App\Models\PaymentMethod;
use App\Models\PaymentType;
use App\Models\Mikopo;
use App\Models\LoanPayment;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    //
    public function adminDashboard() {

        $hisa = Hisa::all();
        $hisapayments = Hisa::where('status',1)->sum('amount');
        $akibapayments = Akiba::sum('amount');
        $loans = Mikopo::where('status',1)->sum('total_repaid_loan_tsh');
        $loans_interest_tsh = Mikopo::where('status',1)->sum('total_interest_tsh');
        $principle_amount = Mikopo::where('status',1)->sum('amount_given');
        $querymonth = $hisa->where('created_at');

        return view('admin.admin_dashboard', compact('hisapayments','akibapayments','querymonth','loans_interest_tsh', 'loans', 'principle_amount'));

    } // end of method

    public function memberDashboard() {
        $hisa = Hisa::select('membership_no')->where('id', Auth::user()->id);
        //$hisapayments = Hisa::where('status',1)->sum('amount');
        $hisapayments = Hisa::where('member_id', Auth::user()->id)->where('status',1)->sum('amount');
        $akibapayments = Akiba::where('member_id', Auth::user()->id)->sum('amount');
        $loans = Mikopo::where('member_id', Auth::user()->id)->where('status',1)->sum('amount_given');
        $loans_interest_tsh = Mikopo::where('member_id', Auth::user()->id)->where('status',1)->latest()->sum('total_interest_tsh');
        $principle_amount = Mikopo::where('member_id', Auth::user()->id)->where('status',1)->sum('amount_given');
        $c_loans = Mikopo::where('member_id', Auth::user()->id)->where('status',1)->latest()->first();

        $l_payment = LoanPayment::where('member_id', Auth::user()->id)->sum('amount');
        $querymonth = $hisa->where('created_at');

        $c_loans_int = ($c_loans->amount_given ?? 0) + ($c_loans->total_interest_tsh ?? 0) - ($l_payment ?? 0);

        return view('members.member_dashboard', compact('hisa','hisapayments','akibapayments','querymonth','loans_interest_tsh', 'loans', 'principle_amount','c_loans','c_loans_int'));
    }
    // end of method
}
